/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.frontends.idl;

import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.util.StringFunctions;

public final class ErrorFormat {
    public static String[] formatExpectedLookaheadList(int[][] expectedTokenSequences, String[] tokenImage, ErrorReporter er, boolean eofMeansEoln) {
        int index = 0;
        String[] ret = new String[1];
        ret[index] = "";
        for (int i = 0; i < expectedTokenSequences.length; ++i) {
            if (expectedTokenSequences[i].length < 1) continue;
            String str = tokenImage[expectedTokenSequences[i][0]];
            if (str.startsWith("\"") && str.endsWith("\"")) {
                str = str.substring(1, str.length() - 1);
            } else if (str.equals("<EOF>") && eofMeansEoln) {
                str = er.getMesg("Comp.Token.EOLN");
            } else if (str.charAt(0) == '<' && str.charAt(str.length() - 1) == '>') {
                str = er.getMesg("Comp.Token.".concat(String.valueOf(str.substring(1, str.length() - 1))));
            }
            int n = index;
            ret[n] = String.valueOf(ret[n]).concat(String.valueOf(str));
            if (i == expectedTokenSequences.length - 1) continue;
            if (ret[index].length() > (index == 0 ? 50 : 67)) {
                int n2 = index++;
                ret[n2] = String.valueOf(ret[n2]).concat(",");
                String[] tmp = new String[ret.length + 1];
                System.arraycopy(ret, 0, tmp, 0, ret.length);
                ret = tmp;
                ret[index] = "";
                continue;
            }
            int n3 = index;
            ret[n3] = String.valueOf(ret[n3]).concat(", ");
        }
        return ret;
    }

    public static long getColumnFromLexerException(String mesg) {
        char c;
        if (mesg == null) {
            return -1L;
        }
        int i = mesg.indexOf("column ") + "column ".length();
        if (i == -1) {
            return -1L;
        }
        String s = "";
        while (i < mesg.length() && (c = mesg.charAt(i++)) >= '0' && c <= '9') {
            s = String.valueOf(s).concat(String.valueOf(c));
        }
        return s.equals("") ? -1L : Long.parseLong(s);
    }

    public static void showColumn(ErrorReporter er, String src, long column) {
        er.untranslatedMessage(StringFunctions.ISOLatin1NoInvisibles(src));
        String dots = "";
        if (column == (long)-1) {
            column = 9L;
        }
        int i = 0;
        while ((long)i < column - (long)1) {
            dots = String.valueOf(dots).concat(".");
            ++i;
        }
        dots = String.valueOf(dots).concat("^");
        er.untranslatedMessage(dots);
    }

    public static void showExpected(ErrorReporter er, String[] expected, String actualLookahead) {
        if (!expected[0].equals("")) {
            er.add(expected[0].equals(",") || expected[0].indexOf(",") == -1 ? "Comp.expecting1" : "Comp.expecting2", new Object[]{expected[0]});
            for (int i = 1; i < expected.length; ++i) {
                er.add("arg", new Object[]{expected[i]});
            }
        }
        if (actualLookahead != null) {
            er.add("Comp.actuallyGot", new Object[]{actualLookahead});
        }
    }
}

